
#include <nds.h>

#include "_const.h"
#include "maindef.h"
#include "_console.h"
#include "_consoleWriteLog.h"

#include "memtool.h"
#undef safemalloc
#define safemalloc safemalloc_chkmem
#include "lang.h"
#include "resume.h"
#include "procstate.h"
#include "shell.h"
#include "splash.h"
#include "strtool.h"
#include "inifile.h"
#include "internaldrivers.h"
#include "cwl.h"
#include "strpcm.h"
#include "sndeff.h"
#include "PlaySE.h"

#include "OSK.h"

#include "OSKHW.h"

#include "unidef.h"

#include "OnSkin.h"
#include "TextEdit.h"

#include "_GlobalTool_DirectPenRead.h"

TOSK_GlobalInfo OSK_GlobalInfo;

EOSKHW_CharMode OSKHW_CharMode;
bool OSKHW_CharMode_UseNumber;

#include "OSK_KeyMap.h"
#include "OSK_KeyMaps.h"
#include "OSK_KeyMapSelector.h"

static u32 OSK_SelectKeyIdx;

static bool OSK_Shift,OSK_CapsLock;

void OSK_Init(void)
{
  OSKCount=0;
  
  OSKHW_Init();
  
  OSK_KeyMaps_Init();
  
  if(Shell_isJPNmode()==true){
    OSK_KeyMaps_ChangeKeyMapFilename("jpn_handwrite.ini");
    OSKHW_CharMode=OSKHW_CM_JPN_Hiragana;
    OSKHW_CharMode_UseNumber=false;
    }else{
    OSK_KeyMaps_ChangeKeyMapFilename("eng_full.ini");
    OSKHW_CharMode=OSKHW_CM_ENG_Small;
    OSKHW_CharMode_UseNumber=true;
  }

  OSK_SelectKeyIdx=(u32)-1;
  
  OSK_Shift=false;
  OSK_CapsLock=false;
  
  OSKHW_ModelLoad();
  OSKHW_Draw();
}

void OSK_Free(void)
{
  OSKHW_Free();
  
  OSK_KeyMap_Free();
  OSK_KeyMaps_Free();
}

static void OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar wc,bool f)
{
  for(u32 idx=0;idx<OSKCount;idx++){
    TOSK *pkm=&OSK[idx];
    if(pkm->pOrgChars[0]==wc) pkm->Enabled=f;
  }
}

static void OSK_RefreshEnableFlags(void)
{
  for(u32 idx=0;idx<OSKCount;idx++){
    TOSK *pkm=&OSK[idx];
    pkm->Enabled=true;
  }
  
  UnicodeChar wc=DicFind_GetLastWChar();
  
  if((wc==0)||(UnicodeChar('0')<=wc)&&(wc<=UnicodeChar('9'))||(wc==UnicodeChar(','))||(wc==UnicodeChar('.'))){
    }else{
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('0'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('1'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('2'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('3'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('4'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('5'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('6'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('7'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('8'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('9'),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar(','),false);
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar('.'),false);
  }
  
  {
    bool f=false;
    UnicodeChar CanKogakiList[18]={
      /**/ 0x3042,/**/ 0x3044,/**/ 0x3046,/**/ 0x3048,/**/ 0x304a,
      /**/ 0x3064,
      /**/ 0x3084,/**/ 0x3086,/**/ 0x3088,
      /*A*/ 0x30A2,/*C*/ 0x30A4,/*E*/ 0x30A6,/*G*/ 0x30A8,/*I*/ 0x30Aa,
      /*c*/ 0x30C4,
      /**/ 0x30E4,/**/ 0x30E6,/**/ 0x30E8,
    };
    for(u32 idx=0;idx<18;idx++){
      if(wc==CanKogakiList[idx]) f=true;
    }
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar(/**/ 0x5c0f),f);
  }
  
  {
    bool f=false;
    UnicodeChar CanDakutenList[41]={
      /**/ 0x304B,/**/ 0x304D,/**/ 0x304F,/**/ 0x3051,/**/ 0x3053,
      /**/ 0x3055,/**/ 0x3057,/**/ 0x3059,/**/ 0x305B,/**/ 0x305D,
      /**/ 0x305F,/**/ 0x3061,/**/ 0x3064,/**/ 0x3066,/**/ 0x3068,
      /**/ 0x306F,/**/ 0x3072,/**/ 0x3075,/**/ 0x3078,/**/ 0x307B,
      /*E*/ 0x30A6,
      /*J*/ 0x30AB,/*L*/ 0x30AD,/*N*/ 0x30AF,/*P*/ 0x30B1,/*R*/ 0x30B3,
      /*T*/ 0x30B5,/*V*/ 0x30B7,/*X*/ 0x30B9,/*Z*/ 0x30BB,/*\*/ 0x30BD,
      /*^*/ 0x30BF,/*`*/ 0x30C1,/*c*/ 0x30C4,/*e*/ 0x30C6,/*g*/ 0x30C8,
      /*n*/ 0x30CF,/*q*/ 0x30D2,/*t*/ 0x30D5,/*w*/ 0x30D8,/*z*/ 0x30DB,
    };
    for(u32 idx=0;idx<41;idx++){
      if(wc==CanDakutenList[idx]) f=true;
    }
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar(/*J*/ 0x309B),f);
  }
  
  {
    bool f=false;
    UnicodeChar CanHanDakutenList[10]={
      /**/ 0x306F,/**/ 0x3072,/**/ 0x3075,/**/ 0x3078,/**/ 0x307B,
      /*n*/ 0x30CF,/*q*/ 0x30D2,/*t*/ 0x30D5,/*w*/ 0x30D8,/*z*/ 0x30DB,
    };
    for(u32 idx=0;idx<10;idx++){
      if(wc==CanHanDakutenList[idx]) f=true;
    }
    OSK_RefreshEnableFlags_ins_SetEnabled(UnicodeChar(/*K*/ 0x309C),f);
  }
}

static void OSK_Draw_ins_EOT_Single(CglCanvas *pcan,TOSK *pkm,const u16 TextColor)
{
  const u32 px=pkm->Rect.x,py=pkm->Rect.y;
  const u32 w=pkm->Rect.w,h=pkm->Rect.h;
  
  switch(pkm->pShow[0]){
    case WC_Enter: {
      const u16 col=TextColor;
      pcan->SetColor(col);
      u32 x=px+(w/2),y=py+(h/2);
      x+=2; y-=6;
      pcan->DrawLine(x,y,x,y+12-2);
      y+=12-2;
      pcan->DrawLine(x,y,x-6,y);
      x-=6;
      pcan->SetPixel(x+2,y-2,col);
      pcan->SetPixel(x+1,y-1,col);
      pcan->SetPixel(x+2,y+2,col);
      pcan->SetPixel(x+1,y+1,col);
      pcan->SetPixel(x,y,col);
    } break;
    case WC_Space: {
      const u16 col=TextColor;
      pcan->SetColor(col);
      u32 x=px+(w/2),y=py+(h/2);
      x-=4; y+=4;
      pcan->SetPixel(x,y-1,col);
      pcan->DrawLine(x,y,x+8+1,y);
      x+=8;
      pcan->SetPixel(x,y-1,col);
    } break;
    case WC_BackSpace: {
      const u16 col=TextColor;
      pcan->SetColor(col);
      u32 x=px+(w/2),y=py+(h/2);
      x+=4;
      pcan->DrawLine(x,y,x-8,y);
      x-=8;
      pcan->SetPixel(x+2,y-2,col);
      pcan->SetPixel(x+1,y-1,col);
      pcan->SetPixel(x+2,y+2,col);
      pcan->SetPixel(x+1,y+1,col);
      pcan->SetPixel(x,y,col);
    } break;
    case WC_Change: {
      CglTGF *ptgf=pSkinOSK_KeyB;
      const u32 tw=ptgf->GetWidth();
      const u32 th=ptgf->GetHeight();
      ptgf->BitBlt(pcan,px+((w-tw)/2),py+((h-th)/2));
    } break;
    case WC_Shift: {
      const u16 col=TextColor;
      pcan->SetColor(col);
      u32 x=px+(w/2),y=py+(h/2);
      y-=5;
      pcan->SetPixel(x,y,col); y++;
      pcan->SetPixel(x+1,y,col); pcan->SetPixel(x-1,y,col); y++;
      pcan->SetPixel(x+2,y,col); pcan->SetPixel(x-2,y,col); y++;
      pcan->SetPixel(x+3,y,col); pcan->SetPixel(x-3,y,col); y++;
      pcan->SetPixel(x+4,y,col); pcan->SetPixel(x-4,y,col); y++;
      
      pcan->SetPixel(x+4,y,col); pcan->SetPixel(x-4,y,col);
      pcan->SetPixel(x+3,y,col); pcan->SetPixel(x-3,y,col);
      pcan->SetPixel(x+2,y,col); pcan->SetPixel(x-2,y,col); y++;
      
      pcan->SetPixel(x+2,y,col); pcan->SetPixel(x-2,y,col); y++;
      pcan->SetPixel(x+2,y,col); pcan->SetPixel(x-2,y,col); y++;
      pcan->SetPixel(x+2,y,col); pcan->SetPixel(x-2,y,col); y++;
      
      pcan->SetPixel(x+2,y,col); pcan->SetPixel(x-2,y,col);
      pcan->SetPixel(x+1,y,col); pcan->SetPixel(x-1,y,col);
      pcan->SetPixel(x+0,y,col);
    } break;
    case WC_CapsLock: {
      const u32 tw=pcan->GetTextWidthA("Ca");
      const u32 th=glCanvasTextHeight;
      pcan->SetFontTextColor(TextColor);
      pcan->TextOutA(px+((w-tw)/2),py+((h-th)/2),"Ca");
    } break;
    case WC_HW_Symbol: case WC_HW_Number: case WC_HW_ENG_Large: case WC_HW_ENG_Small: case WC_HW_JPN_Hiragana: case WC_HW_JPN_Katakana: {
    } break;
    default: {
      const u32 tw=pcan->GetTextWidthW(pkm->pShow);
      const u32 th=glCanvasTextHeight;
      pcan->SetFontTextColor(TextColor);
      pcan->TextOutW(px+((w-tw+1)/2),py+((h-th+1)/2),pkm->pShow);
    } break;
  }
  
  bool FillBG=false;
  switch(pkm->pOrgChars[0]){
    case WC_Enter: break;
    case WC_Space: break;
    case WC_BackSpace: break;
    case WC_Change: break;
    case WC_Shift: if(OSK_Shift==true) FillBG=true; break;
    case WC_CapsLock: if(OSK_CapsLock==true) FillBG=true; break;
    case WC_HW_Number: if(OSKHW_CharMode_UseNumber==true) FillBG=true; break;
    case WC_HW_Symbol: if(OSKHW_CharMode==OSKHW_CM_Symbol) FillBG=true; break;
    case WC_HW_ENG_Large: if(OSKHW_CharMode==OSKHW_CM_ENG_Large) FillBG=true; break;
    case WC_HW_ENG_Small: if(OSKHW_CharMode==OSKHW_CM_ENG_Small) FillBG=true; break;
    case WC_HW_JPN_Hiragana: if(OSKHW_CharMode==OSKHW_CM_JPN_Hiragana) FillBG=true; break;
    case WC_HW_JPN_Katakana: if(OSKHW_CharMode==OSKHW_CM_JPN_Katakana) FillBG=true; break;
    default: break;
  }
  
  if(FillBG==true) OnSkin_FillBox50per(pcan,px+2,py+2,w-2-1,h-2-1,RGB15(20,28,31));
}

static u32 OSK_GetShiftStateIndex(TOSK *pkm)
{
  bool Shift=OSK_Shift;
  if(OSK_CapsLock==true){
    Shift=!Shift;
/*
    UnicodeChar wc=pkm->pShow[0];
    if(('a'<=wc)&&(wc<='z')) Shift=!Shift;
    if(('A'<=wc)&&(wc<='Z')) Shift=!Shift;
*/
  }
  
  if(Shift==false){
    return(0);
    }else{
    return(1);
  }
}

static void OSK_Draw_ins_EOT_Shift(CglCanvas *pcan,TOSK *pkm,const u16 TextColor)
{
  const u32 px=pkm->Rect.x,py=pkm->Rect.y;
  const u32 w=pkm->Rect.w,h=pkm->Rect.h;
  
  const UnicodeChar str[2]={pkm->pShow[OSK_GetShiftStateIndex(pkm)],0};
  
  const u32 tw=pcan->GetTextWidthW(str);
  const u32 th=glCanvasTextHeight;
  pcan->SetFontTextColor(TextColor);
  pcan->TextOutW(px+((w-tw)/2),py+((h-th)/2),str);
}

void OSK_Draw(CglCanvas *pcan)
{
  OSK_RefreshEnableFlags();
  
  for(u32 idx=0;idx<OSKCount;idx++){
    TOSK *pkm=&OSK[idx];
    u16 FrameColor,BGColor,TextColor;
    if(idx==OSK_SelectKeyIdx){
      FrameColor=RGB15(0,0,0)|BIT15;
      BGColor=RGB15(15,30,15)|BIT15;
      TextColor=RGB15(4,4,4)|BIT15;
      }else{
      if(pkm->Enabled==false){
        FrameColor=RGB15(24,24,24)|BIT15;
        BGColor=RGB15(31,31,31)|BIT15;
        TextColor=RGB15(24,24,24)|BIT15;
        }else{
        FrameColor=RGB15(16,16,16)|BIT15;
        BGColor=RGB15(31,31,31)|BIT15;
        TextColor=RGB15(4,4,4)|BIT15;
      }
    }
    
    const u32 px=pkm->Rect.x,py=pkm->Rect.y;
    const u32 w=pkm->Rect.w,h=pkm->Rect.h;
    
    pcan->SetColor(FrameColor);
    pcan->DrawBox(px+1,py+1,w-1,h-1);
    
    OnSkin_FillBox50per(pcan,px+2,py+2,w-1-2,h-1-2,BGColor);
    
    switch(pkm->OrgType){
      case EOT_Single: OSK_Draw_ins_EOT_Single(pcan,pkm,TextColor); break;
      case EOT_Shift: OSK_Draw_ins_EOT_Shift(pcan,pkm,TextColor); break;
      case EOT_Multi5: break;
    }
  }
}

static u32 OSK_GetKeyIdxFromPoint(s32 mx,s32 my)
{
  for(u32 idx=0;idx<OSKCount;idx++){
    TOSK *pkm=&OSK[idx];
    if(pkm->Enabled==true){
      const u32 x=pkm->Rect.x,y=pkm->Rect.y;
      const u32 w=pkm->Rect.w,h=pkm->Rect.h;
      if((x<=mx)&&(mx<(x+w))&&(y<=my)&&(my<(y+h))) return(idx);
    }
  }
  return((u32)-1);
}

static bool MouseHandWriteFlag=false;

bool OSK_KeyPress(u32 keys)
{
  if(OSKHW_KeyPress(keys)==true) return(true);
  
  return(false);
}

bool OSK_MouseDown(s32 mx,s32 my)
{
  OSK_SelectKeyIdx=OSK_GetKeyIdxFromPoint(mx,my);
  if(OSK_SelectKeyIdx==(u32)-1){
    if(OSKHW_MouseDown(mx,my)==true){
      RequestRedrawMainFlag=true;
      OSKHW_Draw();
      MouseHandWriteFlag=true;
      return(true);
    }
    return(false);
  }
  
  if(OSK[OSK_SelectKeyIdx].pOrgChars[0]==WC_Change){
    OSK_SelectKeyIdx=(u32)-1;
    DicFind_Clear();
    u32 nextidx=OSK_KeyMapSelector_Execute();
    if(nextidx!=(u32)-1){
      PlaySE_Long();
      if(OSK_KeyMaps_GetKeyMapIndex()!=nextidx){
        OSKHW_Free();
        OSK_KeyMaps_ChangeKeyMapIndex(OSK_KeyMapSelector_ItemIndex);
      }
      OSKHW_ModelLoad();
      OSKHW_Draw();
    }
    RequestRedrawMainFlag=true;
    RequestRedrawSubFlag=true;
    return(false);
  }
  
  RequestRedrawMainFlag=true;
  return(true);
}

void OSK_MouseMove(s32 mx,s32 my)
{
  if(MouseHandWriteFlag==true){
    OSKHW_MouseMove(mx,my);
    return;
  }
  
  if(OSK_SelectKeyIdx==(u32)-1) return;
  
  if(OSK_SelectKeyIdx!=OSK_GetKeyIdxFromPoint(mx,my)){
    OSK_SelectKeyIdx=(u32)-1;
    RequestRedrawMainFlag=true;
  }
}

static bool RequestShiftClear;

static void OSK_MouseUp_ins_EOT_Single(TOSK *pkm)
{
  UnicodeChar wc=pkm->pOrgChars[0];
  
  switch(wc){
    case WC_Enter: case WC_Space: case WC_BackSpace: {
      if(OSKHW_OSKButtonPressCallBack(wc)==false){
        CB_KeyPress_FromOSK(wc,true);
      }
    } break;
    case WC_Change: break;
    case WC_Shift: {
      PlaySE_Short();
      OSK_Shift=!OSK_Shift;
      RequestRedrawSubFlag=true;
      RequestShiftClear=false;
    } break;
    case WC_CapsLock: {
      PlaySE_Long();
      OSK_CapsLock=!OSK_CapsLock;
      RequestRedrawSubFlag=true;
    } break;
    case WC_HW_Symbol: case WC_HW_Number: case WC_HW_ENG_Large: case WC_HW_ENG_Small: case WC_HW_JPN_Hiragana: case WC_HW_JPN_Katakana: {
      PlaySE_Long();
      switch(wc){
        case WC_HW_Number: {
          if(OSKHW_CharMode_UseNumber==false){
            OSKHW_CharMode_UseNumber=true;
            }else{
            OSKHW_CharMode_UseNumber=false;
          }
        } break;
        case WC_HW_Symbol: OSKHW_CharMode=OSKHW_CM_Symbol; break;
        case WC_HW_ENG_Large: OSKHW_CharMode=OSKHW_CM_ENG_Large; break;
        case WC_HW_ENG_Small: OSKHW_CharMode=OSKHW_CM_ENG_Small; break;
        case WC_HW_JPN_Hiragana: OSKHW_CharMode=OSKHW_CM_JPN_Hiragana; break;
        case WC_HW_JPN_Katakana: OSKHW_CharMode=OSKHW_CM_JPN_Katakana; break;
      }
      RequestRedrawSubFlag=true;
    } break;
    case 0: break;
    default: {
      if(OSKHW_OSKButtonPressCallBack(wc)==false){
        CB_KeyPress_FromOSK(wc,true);
      }
    } break;
  }
}

static void OSK_MouseUp_ins_EOT_Shift(TOSK *pkm)
{
  UnicodeChar wc=pkm->pShow[OSK_GetShiftStateIndex(pkm)];
  
  if(OSKHW_OSKButtonPressCallBack(wc)==false){
    CB_KeyPress_FromOSK(wc,true);
  }
}

void OSK_MouseUp(s32 mx,s32 my)
{
  if(MouseHandWriteFlag==true){
    MouseHandWriteFlag=false;
    OSKHW_MouseUp(mx,my);
    OSKHW_Draw();
    RequestRedrawMainFlag=true;
    return;
  }
  
  if(OSK_SelectKeyIdx==(u32)-1) return;
  
  TOSK *pkm=&OSK[OSK_SelectKeyIdx];
  
  {
    UnicodeChar wc=pkm->pOrgChars[0];
    switch(wc){
      case WC_Enter: break;
      case WC_Space: break;
      case WC_BackSpace: break;
      case WC_Change: break;
      case WC_Shift: break;
      case WC_CapsLock: break;
      case WC_HW_Symbol: case WC_HW_Number: case WC_HW_ENG_Large: case WC_HW_ENG_Small: case WC_HW_JPN_Hiragana: case WC_HW_JPN_Katakana: break;
      case 0: break;
      default: Sound_Start(WAVFN_MemoPenDown); break;
    }
  }
  
  RequestShiftClear=true;
  
  switch(pkm->OrgType){
    case EOT_Single: OSK_MouseUp_ins_EOT_Single(pkm); break;
    case EOT_Shift: OSK_MouseUp_ins_EOT_Shift(pkm); break;
    case EOT_Multi5: break;
  }
  
  if(RequestShiftClear==true) OSK_Shift=false;
  
  OSK_SelectKeyIdx=(u32)-1;
  RequestRedrawMainFlag=true;
}

